'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Database
Option Explicit

Private Sub Detailbereich_Format(Cancel As Integer, FormatCount As Integer)
    Dim von, bis As Long                    'Absolute Positionen auf dem Bericht
    Dim Laenge As Double                    '"Spannweite" vom grssten zum kleinsten Wert (in Euro/Minuten),
                                            '   um den Nullpunkt zu ermitteln
    Dim MinBetragProzent, MaxBetragProzent As Double
    Dim MinDauerProzent, MaxDauerProzent As Double
    Dim MinProzent, MaxProzent As Double
    Dim Start, Ende, Nullpunkt As Long      'Start und Ende der zu zeichnenden Linie
    
    von = 6500                             'je nach gewnschter Position auf dem Bericht anzupassen
    bis = 9050
    
    'Bestimmung von Laenge und Nullpunkt
    MinBetragProzent = Me.NettoMin / (Me.NettoSum + 0.0001)
    MaxBetragProzent = Me.NettoMax / (Me.NettoSum + 0.0001)
    
    MinDauerProzent = Me.DauerMin / (Me.DauerSum + 0.0001)
    MaxDauerProzent = Me.DauerMax / (Me.DauerSum + 0.0001)
    
    MinProzent = MinBetragProzent
    If MinDauerProzent < MinBetragProzent Then MinProzent = MinDauerProzent
    If MinProzent = 0 Then MinProzent = 0.0001
    MaxProzent = MaxBetragProzent
    If MaxDauerProzent > MaxBetragProzent Then MaxProzent = MaxDauerProzent
    If MaxProzent = 0 Then MaxProzent = 0.0001
    
    
    If MaxProzent <= 0 Then MaxProzent = 0.0001
    If MinProzent >= 0 Then MinProzent = 0.0001
    If MinProzent < 0 Then MinProzent = MinProzent * (-1)
    
    
    Laenge = MinProzent + MaxProzent
    Nullpunkt = von + Int((MinProzent / Laenge) * (bis - von))
    
    
    'Bestimmung von Start und Ende fr den BETRAG(!)
    If Me.SummeVonKm < 0 Then
        Start = Nullpunkt - Int((((Me.SummeVonKm * (-1)) / (Me.NettoSum + 0.0001)) / MinProzent) * (Nullpunkt - von))
        Ende = Nullpunkt
    Else
        Start = Nullpunkt - 5       '-5 zur Versteckung des linken Kastenrandes hinter die Nullinie
        Ende = Nullpunkt + Int(((Me.SummeVonKm / (Me.NettoSum + 0.0001)) / MaxProzent) * (bis - Nullpunkt))
    End If
    'bei negativen Werten: rote Linie
    If Me.SummeVonKm < 0 Then
        Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
    Else
        Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
    End If
    'Balken im Bericht zeichnen
    Me.Line (Start, 250)-(Ende, 400), , B
    
    
    
    'Bestimmung von Start und Ende fr den ZEITAUFWAND(!)
    If Me.SummeVonDauer < 0 Then
        Start = Nullpunkt - Int((((Me.SummeVonDauer * (-1)) / (Me.DauerSum + 0.0001)) / MinProzent) * (Nullpunkt - von))
        Ende = Nullpunkt
    Else
        Start = Nullpunkt - 5       '-5 zur Versteckung des linken Kastenrandes hinter die Nullinie
        Ende = Nullpunkt + Int(((Me.SummeVonDauer / (Me.DauerSum + 0.0001)) / MaxProzent) * (bis - Nullpunkt))
    End If
    'bei negativen Werten: rote Linie
    If Me.SummeVonDauer < 0 Then
        Me.ForeColor = RGB(RGB_MinusRot, RGB_MinusGruen, RGB_MinusBlau)         'Negativ
    Else
        Me.ForeColor = RGB(RGB_PlusRot, RGB_PlusGruen, RGB_PlusBlau)            'Positiv
    End If
    'Balken im Bericht zeichnen
    Me.Line (Start, 50)-(Ende, 200), , BF
    
    
    
    'zum Schluss(!) die Nullkoordinate zur Orientierung zeichnen
    Me.ForeColor = RGB(0, 0, 0)                 'Schwarz
    Me.Line (Nullpunkt, 0)-(Nullpunkt, 520)
    
End Sub

Private Sub Report_Activate()
    On Error Resume Next
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Report_Open(Cancel As Integer)
    SchriftartFuerBerichtEinstellen Me
    Me.ImpFusszeile.Caption = ImpressumBerichtsfuss

    Me.Filter = BerichteFilter
    Me.Ueberschrift.Caption = BerichteUeberschrift
    'Me.Jahresfilter.Caption = BerichteJahreswahl
    Me.FilterOn = True
    Me.km_Text.Caption = km_RechText
    Me.km_Einheit.Caption = km_TabellenKuerzel
End Sub
